/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.api.entity.data.IEnchantSet;
import noppes.npcs.entity.data.DropSet;
import noppes.npcs.util.ValueUtil;

public class EnchantSet
implements IEnchantSet {
    public double chance;
    public Enchantment ench;
    public int[] lvls;
    public DropSet parent;

    public EnchantSet(DropSet p) {
        this.parent = p;
        this.lvls = new int[]{0, 1};
        this.ench = Enchantment.func_185262_c((int)0);
        this.chance = 100.0;
    }

    @Override
    public double getChance() {
        return (double)Math.round(this.chance * 10000.0) / 10000.0;
    }

    @Override
    public String getEnchant() {
        return this.ench.func_77320_a();
    }

    public String getKey() {
        String keyName = "";
        char c = '\u00a7';
        double ch = (double)Math.round(this.chance * 10.0) / 10.0;
        String chance = String.valueOf(ch).replace(".", ",");
        if (ch == (double)((int)ch)) {
            chance = String.valueOf((int)ch);
        }
        chance = chance + "%";
        keyName = keyName + c + "e" + chance;
        keyName = this.lvls[0] == this.lvls[1] ? keyName + c + "7[" + c + "6" + this.lvls[0] + c + "7] " : keyName + c + "7[" + c + "6" + this.lvls[0] + c + "7-" + c + "6" + this.lvls[1] + c + "7] ";
        keyName = keyName + c + "7ID:" + Enchantment.func_185258_b((Enchantment)this.ench) + " ";
        keyName = keyName + c + "r" + new TextComponentTranslation(this.ench.func_77320_a(), new Object[0]).func_150254_d();
        keyName = keyName + c + "8 #" + this.toString().substring(this.toString().indexOf("@") + 1);
        return keyName;
    }

    @Override
    public int getMaxLevel() {
        return this.lvls[1];
    }

    @Override
    public int getMinLevel() {
        return this.lvls[0];
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound nbtES = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagInt(this.lvls[0]));
        list.func_74742_a((NBTBase)new NBTTagInt(this.lvls[1]));
        nbtES.func_74782_a("Levels", (NBTBase)list);
        nbtES.func_74768_a("ID", Enchantment.func_185258_b((Enchantment)this.ench));
        nbtES.func_74780_a("Chance", this.chance);
        return nbtES;
    }

    public void load(NBTTagCompound nbtES) {
        int[] newLv = new int[2];
        for (int i = 0; i < 2; ++i) {
            newLv[i] = nbtES.func_150295_c("Levels", 3).func_186858_c(i);
        }
        this.lvls = newLv;
        this.ench = Enchantment.func_185262_c((int)nbtES.func_74762_e("ID"));
        this.chance = nbtES.func_74769_h("Chance");
    }

    @Override
    public void remove() {
        this.parent.removeEnchant(this);
    }

    @Override
    public void setChance(double chance) {
        double newChance = ValueUtil.correctDouble(chance, 1.0E-4, 100.0);
        this.chance = (double)Math.round(newChance * 10000.0) / 10000.0;
    }

    @Override
    public void setEnchant(Enchantment enchant) {
        if (enchant == null) {
            this.parent.removeEnchant(this);
            return;
        }
        this.ench = enchant;
    }

    @Override
    public boolean setEnchant(int id) {
        Enchantment newEnch = Enchantment.func_185262_c((int)id);
        if (newEnch != null) {
            this.ench = newEnch;
            return true;
        }
        return false;
    }

    @Override
    public boolean setEnchant(String name) {
        Enchantment newEnch = Enchantment.func_180305_b((String)name);
        if (newEnch != null) {
            this.ench = newEnch;
            return true;
        }
        return false;
    }

    @Override
    public void setLevels(int min, int max) {
        int newMin = min;
        int newMax = max;
        if (min > max) {
            newMin = max;
            newMax = min;
        }
        this.lvls = new int[]{newMin, newMax};
    }
}

